var tocImages =  {'ctrlImageLine':'empty_toc_image',
                  'ctrlImageVoid':'empty_toc_image',
                  'ctrlImage0':'empty_toc_image',
                  'ctrlImage1':'empty_toc_image',
                  'ctrlImage2':'empty_toc_image',
                  'ctrlImage3':'empty_toc_image',
                  'ctrlImage4':'empty_toc_image',
                  'ctrlImage8':'plus_toc_image',
                  'ctrlImage9':'plus_toc_image',
                  'ctrlImage10':'plus_toc_image',
                  'ctrlImage11':'plus_toc_image',
                  'ctrlImage12':'minus_toc_image',
                  'ctrlImage13':'minus_toc_image',
                  'ctrlImage14':'minus_toc_image',
                  'topic-opened':'topic_opened_toc_image',
                  'topic-closed':'topic_closed_toc_image',
                  'topic':'topic_toc_image'};
var childTrees=[];
var curViewed;

// ------------------------------------------ Functions for nodes expansion

var chgNodeResult=0;

function expandTOCNode(nodeId)
{
    if(curViewed != null && curViewed.nodeId == nodeId)
        return;
    chgNodeResult = -1;
    expandTOCNodeChilds(nodeId, top.contentTree);
    return chgNodeResult;
}

function expandTOCNodeChilds(nodeId, parentNode)
{
	if (parentNode.children) {
		for(var i = 0; i < parentNode.children.length; i++)
		{
            var child = parentNode.children[i];
//			if (!child.parent) child.parent = parentNode;
            if (!child.isRendered) initTocNode(child, parentNode);
            if(child.opn) child.OpenCloseNode(false);
			if(nodeId == child.id)
			{
				ExpandNode(child);
				child.select(false);
				chgNodeResult = nodeId;
				return;
			};
			expandTOCNodeChilds(nodeId, child);
		};
	}
}

function renderNode(parent, node){
    parent.innerHTML += node.init();
}

function ExpandAllOpened(nodePointer) {
	if (nodePointer.opn) {
		ExpandNode(nodePointer);
	}
	if (nodePointer.children) {
		for (var i = 0; i<nodePointer.children.length;i++) {
			ExpandAllOpened(nodePointer.children[i]);
		}
	}
}

function ExpandNode(nodePointer)
{
    if(nodePointer.parent == null) {
		return;
	} else {
		ExpandNode(nodePointer.parent);
		nodePointer.OpenCloseNode(false);
	}
}

// ------------------------------------------ TOCNode class

function isFirstNode()
{
    return this.preceding == null;
}

function isLastNode()
{
    return this.following == null;
}

function SetNodeImage(setCtrlImage)
{
    if(setCtrlImage)
    {
        var flags = 0;
        if(this.children) {
			flags |= 0x8;
		}
        if(this.children && this.opn) {
			flags |= 0x4;
		}
        if(this.isLastNode()) {
			flags |= 0x2;
		}
        if(this.isFirstNode()) {
			flags |= 0x1;
		}
        return tocImages['ctrlImage' + flags];
    }
    else
    {
        var currentState;
		if (!this.children) {
			currentState =  top.tocIcons[this.ic]+"_toc_image";
		} else if (this.opn) {
			currentState = top.tocIcons[this.ic]+'_opened_toc_image';
		} else {
			currentState = top.tocIcons[this.ic]+'_closed_toc_image';
		}
        return currentState;
    }
}

function OpenCloseNode(currentState)
{
	if (currentState == null) {
		currentState = this.opn;
	}
	var htmlContent = [];
    var childDiv = document.getElementById('divtree' + this.id);
    if(!childDiv) return;
    if(!childDiv.innerHTML)
    {
        for(var i = 0; i < this.children.length; i++){
            initTocNode(this.children[i], this);
            htmlContent[i] = this.children[i].init();
		}
        childDiv.innerHTML = htmlContent.join('');
    }
    if(currentState) childDiv.style.display = 'none';
    else childDiv.style.display = 'block';
    this.opn = !currentState;
    var controlImage = document.getElementById('ctrlImage' + this.id),
        bookImage = document.getElementById('bookImage' + this.id);
    if(controlImage) {
		controlImage.className  = this.NodeImage(true)
	}
    if(bookImage) {
		bookImage.className = this.NodeImage(false);
	}
}

function ViewNode(onoffPrevious)
{
    if(!onoffPrevious)
    {
        var viewedNode = curViewed;
        if(viewedNode) viewedNode.select(true);
        top.changeCurrPageNumber(this.id);
    }
	curViewed = this;
    var bookImage = document.getElementById('bookImage' + this.id);
    if(bookImage) bookImage.setAttribute("class",this.NodeImage());
    document.getElementById('nodeAhchor' + this.id).className = onoffPrevious ? 'toc_normal' : 'toc_selected';
    return Boolean(this.ttl);
}

function InitializeNode()
{
    var parentNodesHTML = [], parentNode = this.parent;
    var navImage;
    var resNodeHTML;
    var i = 0;
    while (parentNode.parent != null) {
        if (parentNode.isLastNode()) navImage = 'ctrlImageVoid';
        else navImage = 'ctrlImageLine';
        parentNodesHTML[i] = '<span class="' + tocImages[navImage] + '" border="0"></span>';
        parentNode = parentNode.parent;
        i++;
    }

    resNodeHTML = '<a name="#nodeAhchor' + this.id + '"></a><nobr><div class="toc_entry">';
    resNodeHTML += parentNodesHTML.join('');

    if (this.children) {
        resNodeHTML += '<a href="javascript:childTrees[\'' + this.id + '\'].toggle()">';
        resNodeHTML += '<span class="' + this.NodeImage(true) + '" border="0" id="ctrlImage' + this.id + '"></span>';
        resNodeHTML += '</a>';
    } else {
        resNodeHTML += '<span class="' + this.NodeImage(true) + '" border="0"></span>';
    }
    resNodeHTML += '<a href="' + this.ln + '" target="content" onclick="top.addTOCHistoryItem(\'' + this.id + '\');return childTrees[\'' + this.id + '\'].select(false);" ondblclick="childTrees[\'' + this.id + '\'].toggle()" class="treeitem" id="nodeAhchor' + this.id + '">';
    resNodeHTML += '<span class="' + this.NodeImage() + '" id="bookImage' + this.id + '" ></span>';
    resNodeHTML += '<span class="tree_entry_title">' + this.ttl + '</span></a></div></nobr>';
    if (this.children)
        resNodeHTML += '<div id="divtree' + this.id + '" style="display:none"></div>';
    this.isRendered = true;
    return resNodeHTML;
}

function initTOC(tocItems)
{
	var root = new Object();

	root.expandTOCNode = expandTOCNode;


	root.previous = null;
	root.following = null;
	root.parent = null;
	root.id = 'root_node';
	root.opn = true;

	root.children = tocItems;
	assignNodeMethods(root);
    var html = "";
    for(var i = 0; i < tocItems.length; i++) {
		var node = initTocNode(tocItems[i], root);
        html += node.init();
    }
    document.write(html);
    curViewed = root.children[i];
	ExpandAllOpened(root);
	return root;
}

function assignNodeMethods(node) {
	node.getChild = getChild;
	node.getPreceding = getPreceding;
	node.getFollowing = getFollowing;
	node.NodeImage = SetNodeImage;
	node.OpenCloseNode = OpenCloseNode;
	node.toggle = OpenCloseNode;
	node.select = ViewNode;
	node.init = InitializeNode;
	node.isLastNode = isLastNode;
	node.isFirstNode = isFirstNode;

	childTrees[node.id] = node;
}

function getChild(id) {
	if (this.children) {
		for (var i = 0; i < this.children.length; i++) {
			if (this.children[i].id == id) {
				return this.children[i];
			}
		}
	}
	return null;
}

function getPreceding(id) {
	var currentNum = -1;
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].id == id) {
			currentNum = i;
			break;
		}
	}
	if (currentNum > 0) {
		return this.children[currentNum-1];
	} else {
		return null;
	}
}

function getFollowing(id) {
	var currentNum = this.children.length;
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].id == id) {
			currentNum = i;
			break;
		}
	}
	if (currentNum < this.children.length-1) {
		return this.children[currentNum+1];
	} else {
		return null;
	}
}

function initTocNode(node,parent) {
	node.isRendered = false;
    node.parent = parent;
	node.preceding = parent.getPreceding(node.id);
	node.following = parent.getFollowing(node.id);
	assignNodeMethods(node);
/*
    if (node.children) {
        for (var i = 0; i < node.children.length; i++) {
            if (node.opn) {
                initTocNode(node.children[i], node);
            }

		}
    }
*/
    return node;
}



// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFGZE1SzZqSPW
// SIG // KT4nA89LJJnM75f8oIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFAyrSF+y3rYcKZ+kbrZSuD4dSAF0MFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYCY
// SIG // EdJGyQ9EXiXpEk2QaZuKZnByBycYZ+3OBRv3bXeUg10m
// SIG // ZAUk7XNTwGhTNDZmvvA/fSh0dhPbEpDqvz7S18IcaAZ0
// SIG // sULx+KIJik77Kwo4bRGgE0Efp7fkqrJBiKI2VuU4up7Q
// SIG // xXWSrwJ93qYXRitb6docTj75ZaghcdbOq1dKAaGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjMzMTE5
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUyKotw4H6MzriWgrIBAzT
// SIG // Y6Z/uIswDQYJKoZIhvcNAQEBBQAEgYCykxsU/K6OZEYY
// SIG // ikaPPj4hieKNAibZXkkAO26Ts4NOtpOTF/nAyL3aPwUV
// SIG // 0YTk8q8mRXjBIDgNk1ZHh9OToUD/4wfcvQHpCewdv6Ii
// SIG // 5epbWMesPjTzLjkHaRXNQYo/P9AeXlacfeXo85qwqxsR
// SIG // JOCfAymEj7F3HaY2wAa04qxs9w==
// SIG // End signature block
